#include "utility.hpp"

using namespace std;

/**
	Config
**/
int conf::TOUR_AVANT_IGNORE = 8;
int conf::MIN_MAX_PROFOND = 1;

double conf::eval_coeff_points = 100.;
double conf::eval_coeff_positions = 100.;
double conf::eval_perte_time = 0.25;

int stats::nbEnemyAttacks = 0;

/**
	Simple functions
**/

int normeUn(position pos) {
	return abs(pos.ligne) + abs(pos.colonne);
}

/**
	Operators
**/

position operator + (const position& a, const position& b) {
	return {a.ligne + b.ligne, a.colonne + b.colonne};
}
position operator - (const position& a, const position& b) {
	return {a.ligne - b.ligne, a.colonne - b.colonne};
}
position operator * (const position& a, int m) {
	return {a.ligne * m, a.colonne * m};
}

bool operator < (const DeySit& a, const DeySit& b) {
	return a.time > b.time;
}

